qui {

noi {
	/*****************************************************/
	/***** Step 2.7.2. Full-sample confidence intervals	**/
	/*****************************************************/
}

	* STEP 1: compute CI's
			
		* Compute country-specific CI's
			
			* STEP 1: compute confidence intervals & se's for NIC-specific independence dividend estimates
			cd ..
			noi di ""
			noi di "Computing confidence intervals for NIC (/$totalNICs):", _continue
			local count = 0
			foreach cntry of global NICs {
				
				* Track progress
				local count = `count' + 1
				noi di `count', _continue
				
				* Load data
				cd ".\3. Intermediary results\3.4. Intermediaries"
				use total_file, clear
				cd ..
				cd ..
				local min = `cntry'*1000
				local max = `cntry'*1000 + 999
				keep if cntrycode == `cntry' | cntrycode >= `min' &  cntrycode <= `max'
				
				sum cntrycode
				if `r(N)' != 0 { 
				
					* Generate corrected independence dividends, CI's & se's
					gen PTDIDD = .
					gen PTDIDD_ll = .
					gen PTDIDD_ul = .
					gen PTDIDD_se = .
					gen pvalue = .
					
					sum independence_years if cntrycode == `cntry'
					foreach year of numlist `r(min)'/`r(max)' {
						local pointestimate
						sum bc_lgap if independence_years == `year' & cntrycode == `cntry'
						cap local pointestimate = `r(mean)'
						sum bc_lgap if independence_years == `year' & cntrycode > 400
						cap replace PTDIDD = bc_lgap-`r(mean)' if independence_years == `year' & cntrycode == `cntry'
						cap replace PTDIDD_ll = PTDIDD+invttail((`r(N)'-1),.975)*`r(sd)' if independence_years == `year' & cntrycode == `cntry'
						cap replace PTDIDD_ul = PTDIDD+invttail((`r(N)'-1),.025)*`r(sd)' if independence_years == `year' & cntrycode == `cntry'
						cap replace PTDIDD_se = `r(sd)' if independence_years == `year' & cntrycode == `cntry'
						cap replace pvalue = 2*ttail(`r(N)',abs((`pointestimate'-`r(mean)')/`r(sd)')) if independence_years == `year' & cntrycode == `cntry'
						}
						
					* Save results 
					cd ".\3. Intermediary results\3.4. Intermediaries"
					keep cntry cntrycode independence_years PTDIDD* year pvalue
					keep if cntrycode == `cntry'
					keep if PTDIDD != .
					save IDD1_ci_`cntry', replace
					cd ..
					cd ..
					}
				}
			
			* STEP 2: Gather all results
			clear all
			cd ".\3. Intermediary results\3.4. Intermediaries"
			foreach cntry of global NICs {
				cap append using IDD1_ci_`cntry'
				}
			cd ..
			save IDD1_ci, replace
			cd ..
		
		* Bootstrap aggregate CI's
		noi di ""
		noi di ""
		noi di "Estimating bootstrapped confidence intervals for aggregate independence dividend estimates, iteration (/${firststepreps}):", _continue
		noi di ""
		
			* Get data
			cd ".\3. Intermediary results\3.4. Intermediaries"
			use total_file, clear
			cd ..
			cd ..
		
			* Compute aggregate independence dividend
			preserve
			collapse (mean) bc_lgap  [w=popshare] if cntrycode < 400, by(independence_years)
			gen iteration = 0	
			tempfile bs
			save `bs', emptyok
			restore

			* Bootstrap placebo-estimates
			cd ".\3. Intermediary results\3.4. Intermediaries"
			foreach iteration of numlist 1/$firststepreps {
				noi di `iteration', _continue
				preserve
				gen cntrycode_NIC = cntrycode if cntrycode < 400
				replace cntrycode_NIC = round(cntrycode/1000) if cntrycode > 400
				bsample 1 if cntrycode > 400, cluster(cntrycode) strata(cntrycode_NIC)
				collapse (mean) bc_lgap [w=popshare], by(independence_years)
				gen iteration = `iteration'
				append using `bs', force
				save `bs', replace
				restore
				}
			
			* Get actual and bootstrapped placebo results
			use `bs'
			sort iteration independence_years
			cd ..
			cd ..
			
			* Compute aggregate CI's
			gen PTDIDD = .
			gen PTDIDD_ll = .
			gen PTDIDD_ul = .
			gen PTDIDD_se = .

			foreach year of numlist -10/30 {
				sum bc_lgap if independence_years == `year' & iteration != 0
				cap replace PTDIDD = bc_lgap-`r(mean)' if independence_years == `year' & iteration == 0
				cap replace PTDIDD_ll = PTDIDD+invttail((`r(N)'-1),.975)*`r(sd)' if independence_years == `year' & iteration == 0
				cap replace PTDIDD_ul = PTDIDD+invttail((`r(N)'-1),.025)*`r(sd)' if independence_years == `year' & iteration == 0
				cap replace PTDIDD_se = `r(sd)' if independence_years == `year' & iteration == 0
				}
				
			* Plot aggregate (raw) independence dividend estimates + 95% CI
			preserve
			keep if iteration == 0
			sort iteration independence_years
			keep independence_years iteration PTDIDD*
			
			noi list independence_years PTDIDD PTDIDD_se if independence_years == 0 | independence_years == 1 | independence_years == 5 | independence_years == 10 | independence_years == 15 | independence_years == 20 | independence_years == 25 | independence_years == 30
			
			gen refline = 0
			twoway 	(rarea PTDIDD_ll PTDIDD_ul independence_years, astyle(ci2) acolor(gs14)) || ///
					(line refline independence_years, lcolor(red)) || ///
					(connected PTDIDD independence_years, lcolor(gs0) mlcolor(gs0) mfcolor(gs0) msymbol(O)) || ///
					if independence_years >= -10 & independence_years <= 30 || ///
					, legend(off) ytitle("Independence dividend", size(large)) xtitle("Years of independence", size(large)) xline(0, lcolor(red) lpattern(dot) lstyle(foreground)) yline(0, lstyle(foreground) lcolor(gs0) lpattern(dot)) graphregion(color(white)) bgcolor(white) ///
					note("with 95% confidence interval")
			cd ".\5. TeX results"
			graph export figure10_1.pdf, replace
			cd ..
			
			* Save results
			cd ".\3. Intermediary results"
			save baseline_results, replace
			cd ..
			
			* Get baseline & trend-demeaned estimates
			cd ".\3. Intermediary results"
			use TDIDD1, clear
			
			* Add (trend-demeaned and) placebo-demeaned estimates
			merge 1:1 cntrycode year using IDD1_ci
			drop _merge
			cd ..
			
			* Plot implications
			keep if independence_years >= 0 | independence_years <= 30
			
			twoway 	(scatter TDIDD PTDIDD, msymbol(Oh) mcolor(gs0) msize(medium)) ///
					(line TDIDD TDIDD, lwidth(thick) lcolor(red) lpattern(solid) lwidth(thin)) ///
			, ytitle("Trend-demeaned independence dividends", size(medlarge)) xtitle("Trend-and-placebo-demeaned independence dividends", size(medlarge)) graphregion(color(white)) bgcolor(white) legend(order(2 "45°-line"))
			cd ".\5. TeX results"
			graph export figureA4_2.pdf, replace
			cd ..
			noi sum TDIDD PTDIDD
			restore
					
	* STEP 2. Report implications
	
		* Get data
		cd ".\3. Intermediary results\3.4. Intermediaries"
		use total_file, clear
		cd ..
		gen cntrycode_helpme = cntrycode
		replace cntrycode = round(cntrycode/1000) if cntrycode > 400
		merge m:1 cntrycode year using IDD1_p, keepusing(pvalue)
		drop _merge
		replace cntrycode = cntrycode_helpme
		drop cntrycode_helpme
		cd ..
					 
		* Compute aggregate independence dividend
		
			* All estimates
			preserve
			bysort independence_years: egen n = count(bc_lgap) if cntrycode < 400
			collapse (mean) bc_lgap n  [w=popshare] if cntrycode < 400, by(independence_years)
			gen iteration = 0	
			tempfile bs
			save `bs', emptyok
			restore
			
			* Statistically significant estimates
			preserve
			drop if pvalue > .1
			bysort independence_years: egen n = count(bc_lgap) if cntrycode < 400
			collapse (mean) bc_lgap n  [w=popshare] if cntrycode < 400, by(independence_years)
			gen iteration = 0	
			tempfile bs2
			save `bs2', emptyok
			restore

		* Bootstrap placebo-estimates
		cd ".\3. Intermediary results\3.4. Intermediaries"
		foreach iteration of numlist 1/$firststepreps {
			noi di `iteration', _continue
			
				* All estimates
				preserve
				gen cntrycode_NIC = cntrycode if cntrycode < 400
				replace cntrycode_NIC = round(cntrycode/1000) if cntrycode > 400
				bsample 1 if cntrycode > 400, cluster(cntrycode) strata(cntrycode_NIC)
				collapse (mean) bc_lgap  [w=popshare], by(independence_years)
				gen iteration = `iteration'
				append using `bs', force
				save `bs', replace
				restore
				
				* Statistically significant estimates
				preserve
				*drop if pvalue > .1
				gen cntrycode_NIC = cntrycode if cntrycode < 400
				replace cntrycode_NIC = round(cntrycode/1000) if cntrycode > 400
				bsample 1 if cntrycode > 400, cluster(cntrycode) strata(cntrycode_NIC)
				collapse (mean) bc_lgap [w=popshare], by(independence_years)
				gen iteration = `iteration'
				append using `bs2', force
				save `bs2', replace
				restore
				}
		
			* Get population-weighted independence dividends & SE's 
			
				* All estimates
				
					* Get data
					use `bs', clear
					sort iteration independence_years
					
					* Compute aggregate CI's
					gen PTDIDD = .
					gen PTDIDD_se = .

					foreach year of numlist 0/30 {
						sum bc_lgap if independence_years == `year' & iteration != 0
						cap replace PTDIDD = bc_lgap-`r(mean)' if independence_years == `year' & iteration == 0
						cap replace PTDIDD_se = `r(sd)' if independence_years == `year' & iteration == 0
						}
					keep independence_years n PTDIDD PTDIDD_se
					tempfile er
					save `er', emptyok
					
				* Statistically significant estimates
				
					* Get data
					use `bs2', clear
					sort iteration independence_years
					
					* Compute aggregate CI's
					gen PTDIDD = .
					gen PTDIDD_se = .
					

					foreach year of numlist 0/30 {
						sum bc_lgap if independence_years == `year' & iteration != 0
						cap replace PTDIDD = bc_lgap-`r(mean)' if independence_years == `year' & iteration == 0
						cap replace PTDIDD_se = `r(sd)' if independence_years == `year' & iteration == 0
						}
					keep independence_years n PTDIDD PTDIDD_se
					tempfile er2
					save `er2', replace emptyok
					
		* Report statistics
				
			* Set-up
			clear all
			set obs 31
			cd .. 
			cd ..
			
			* Generate necessary variables
			gen independence_years = _n-1
			gen str n_all = ""
			gen str mean_all = ""
			gen str median_all = ""
			gen str se_all = ""
			gen str se2_all = ""
			gen str neg_all = ""
			gen str n_p10 = ""
			gen str mean_p10 = ""
			gen str median_p10 = ""
			gen str se_p10 = ""
			gen str se2_p10 = ""
			gen str neg_p10 = ""
			gen str p_p10 = ""
	
			* Report results
			foreach year of numlist 0/30 { 
				
				* ALL ESTIMATES
				
					* Number of countries
					preserve 
					use `er', clear
					sum n if independence_years == `year'
					restore
					local n_all = `r(mean)'
					replace n_all = "`n_all'" if independence_years == `year'
					
					* Mean effect
					preserve 
					use `er', clear
					sum PTDIDD if independence_years == `year'
					restore
					local mean = round(`r(mean)',.01)
					replace mean_all = "`mean'" if independence_years == `year'
										
					* Cross-sectional SD
					preserve

					use "./3. Intermediary results/IDD1_ci", clear						// Load all estimates
					merge 1:1 cntrycode year using "./4. Master data/master_data.dta"	// Add information on population shares
					keep if _merge == 3
					keep cntry cntrycode year independence_years PTDIDD popshare 
					sum PTDIDD if independence_years == `year' [w=popshare]				// Compute population-weighted independence dividend
					restore
					local se2 = round(`r(sd)',.01)						
					replace se2_all = "`se2'" if independence_years == `year'
										
					* Inferential SE
					preserve 
					use `er', clear
					sum PTDIDD_se if independence_years == `year'
					restore
					local se = round(`r(mean)',.01)
					replace se_all = "`se'" if independence_years == `year'

					* Median effect
					preserve 
					use "./3. Intermediary results/IDD1_ci", clear
					sum PTDIDD if independence_years == `year', d
					restore
					local median = round(`r(p50)',.01)
					replace median_all = "`median'"  if independence_years == `year'
					
					* % Negative
					preserve 
					use "./3. Intermediary results/IDD1_ci", clear
					sum PTDIDD if independence_years == `year' & PTDIDD < 0, d
					local neg = `r(N)'
					sum PTDIDD if independence_years == `year'
					local n_all = `r(N)'
					restore
					local negp = round(`neg'/`n_all'*100,.1)
					replace neg_all = "`neg' (`negp'\%)"   if independence_years == `year'
					
				* STATISTICALLY SIGNIFICANT ESTIMATES
				
					* Number of countries
					preserve 
					use `er2', clear
					sum n if independence_years == `year'
					restore
					local n_p10 = `r(mean)'
					local p = round(`r(mean)'/`n_all'*100,.1)
					replace n_p10 = "`n_p10' (`p'\%)" if independence_years == `year'
					
					* Mean effect
					preserve 
					use `er2', clear
					sum PTDIDD if independence_years == `year'
					restore
					local mean = round(`r(mean)',.01)
					replace mean_p10 = "`mean'" if independence_years == `year'
					
					* Cross-sectional SD
					preserve
					use "./3. Intermediary results/IDD1_ci", clear											// Load all estimates
					merge m:1 cntrycode year using "./3. Intermediary results/IDD1_p", keepusing(pvalue)	// Add information of p-values
					drop if pvalue > .1																		// Retain statistically significant estimates (p<=.1)
					drop _merge
					merge 1:1 cntrycode year using "./4. Master data/master_data.dta"						// Add information on population shares
					keep if _merge == 3
					keep cntry cntrycode year independence_years PTDIDD popshare 
					sum PTDIDD if independence_years == `year' [w=popshare]
					restore
					local se2 = round(`r(sd)',.01)						
					replace se2_p10 = "`se2'" if independence_years == `year'
					
					* Inferential standard error
					preserve 
					use `er2', clear
					sum PTDIDD_se if independence_years == `year'
					restore
					local se = round(`r(mean)',.01)
					replace se_p10 = "`se'" if independence_years == `year'
											
					* Median effect
					preserve 
					use "./3. Intermediary results/IDD1_ci", clear
					merge 1:1 cntrycode independence_years using "./3. Intermediary results/IDD1_p"
					drop if pvalue > .1
					sum PTDIDD if independence_years == `year', d
					restore
					local median = round(`r(p50)',.01)
					replace median_p10 = "`median'"  if independence_years == `year'
					
					* % Negative
					preserve 
					use "./3. Intermediary results/IDD1_ci", clear
					merge 1:1 cntrycode independence_years using "./3. Intermediary results/IDD1_p"
					drop if pvalue > .1
					sum PTDIDD if independence_years == `year' & PTDIDD < 0, d
					local neg = `r(N)'
					sum PTDIDD if independence_years == `year'
					local n_p10 = `r(N)'
					restore
					local negp = round(`neg'/`n_p10'*100,.1)
					replace neg_p10 = "`neg' (`negp'\%)"   if independence_years == `year'
			
			}
			
		duplicates drop independence_years, force	
		keep if independence_years == 1 | independence_years == 5 | independence_years == 10 | independence_years == 15 | independence_years == 20 | independence_years == 25 | independence_years == 30
		cd ".\5. TeX results"	
		listtab independence_years n_all mean_all median_all se_all se2_all neg_all n_p10 mean_p10 median_p10 se_p10 se2_p10 neg_p10  ///
		using table5.tex,  replace ///
		rstyle(tabular) ///
		headlines("\begin{tabular}{lcccccccccccc}\toprule & \multicolumn{6}{c}{\emph{All estimates}}  & \multicolumn{6}{c}{\emph{Statistically significant estimates ($ p \leq .1 $)}} \\ \emph{$ s $} & \emph{n} & \emph{$\bar{\bar{\beta}}$} & \emph{$\beta^{p50}$} & \emph{$\sigma_{\bar{\beta}^{PL}}$} & \emph{$ CSD $} & \emph{$\bar{\beta}_{s} < 0$} & \emph{n} & \emph{$\bar{\bar{\beta}}$} & \emph{$\beta^{p50}$} & \emph{$\sigma_{\bar{\beta}^{PL}}$} & \emph{$ CSD $} & \emph{$\bar{\beta}_{s} < 0$} \\ \cmidrule(lr){2-7} \cmidrule(lr){8-13}") ///
		footlines("\bottomrule \end{tabular}")
		cd ..
				
	* More detailed appendix table
	clear all
	set obs 31
	gen independence_years = _n-1
	gen str p99 = ""
	gen str p95 = ""
	gen str p90 = ""
	
	
	gen str p90_n = ""
	gen str p90_m = ""
	gen str p90_p = ""
	
	gen str pe_mean = ""
	gen str pe_median = ""
	gen str pe_min = ""
	gen str pe_max = ""
	gen str pe_p25 = ""
	gen str pe_p75= ""
	
	foreach year of numlist 0/30 {
		preserve
		use "./3. Intermediary results/IDD1_ci", clear
		merge 1:1 cntrycode independence_years using "./3. Intermediary results/IDD1_p", keepusing(pvalue)
		sum PTDIDD if independence_years == `year'
		local total_obs = `r(N)' 
		sum PTDIDD if independence_years == `year' & pvalue <= .01
		local p99 = round(`r(N)'/`total_obs'*100)
		restore
		replace p99 = "`p99'%" if independence_years == `year'
		preserve
		use "./3. Intermediary results/IDD1_ci", clear
		merge 1:1 cntrycode independence_years using "./3. Intermediary results/IDD1_p", keepusing(pvalue)
		sum PTDIDD if independence_years == `year' & pvalue <= .05
		local p95 = round(`r(N)'/`total_obs'*100)
		restore
		replace p95 = "`p95'%" if independence_years == `year'
		preserve
		use "./3. Intermediary results/IDD1_ci", clear
		merge 1:1 cntrycode independence_years using "./3. Intermediary results/IDD1_p", keepusing(pvalue)
		sum PTDIDD if independence_years == `year' & pvalue <= .1
		local p90 = round(`r(N)'/`total_obs'*100)
		restore
		replace p90 = "`p90'%" if independence_years == `year'
		
		preserve
		use "./3. Intermediary results/IDD1_ci", clear
		merge 1:1 cntrycode independence_years using "./3. Intermediary results/IDD1_p", keepusing(pvalue)
		sum PTDIDD if independence_years == `year' & pvalue <= .1 & PTDIDD < 0
		restore
		local p90_m = `r(N)'
		local p90_mm = round(`r(N)'/`total_obs'*100)		
		replace p90_m = "`p90_m' (`p90_mm'\%)" if independence_years == `year'

		preserve
		use "./3. Intermediary results/IDD1_ci", clear
		merge 1:1 cntrycode independence_years using "./3. Intermediary results/IDD1_p", keepusing(pvalue)
		sum PTDIDD if independence_years == `year' & pvalue <= .1 & PTDIDD > 0
		local p90_p = `r(N)'
		local p90_pp = round(`r(N)'/`total_obs'*100)
		restore
		replace p90_p = "`p90_p' (`p90_pp'\%)" if independence_years == `year'

		preserve
		use "./3. Intermediary results/IDD1_ci", clear
		merge 1:1 cntrycode independence_years using "./3. Intermediary results/IDD1_p", keepusing(pvalue)
		sum PTDIDD if independence_years == `year' & pvalue > .1
		local p90_n = `r(N)'
		local p90_nn = round(`r(N)'/`total_obs'*100)
		restore
		replace p90_n = "`p90_n' (`p90_nn'\%)" if independence_years == `year'
		
		preserve
		use "./3. Intermediary results/IDD1_ci", clear
		merge 1:1 cntrycode independence_years using "./3. Intermediary results/IDD1_p", keepusing(pvalue)
		sum PTDIDD if independence_years == `year', d
		local pe_max = round(r(max)*100)
		local pe_min = round(r(min)*100)
		local pe_mean = round(r(mean)*100)
		local pe_median = round(r(p50)*100)
		local pe_p25 = round(r(p25)*100)
		local pe_p75 = round(r(p75)*100)
		restore
		
		replace pe_mean = "`pe_mean'\%" if independence_years == `year'
		replace pe_median = "`pe_median'\%" if independence_years == `year'
		replace pe_min = "`pe_min'\%" if independence_years == `year'
		replace pe_max = "`pe_max'\%" if independence_years == `year'
		replace pe_p25 = "`pe_p25'\%" if independence_years == `year'
		replace pe_p75 = "`pe_p75'\%" if independence_years == `year'
		}
	
	preserve
	use "./3. Intermediary results/IDD1_ci", clear
		merge 1:1 cntrycode independence_years using "./3. Intermediary results/IDD1_p", keepusing(pvalue)
	noi di ""
	noi di ""
	noi di "% of NICs with statistically significant independence dividend estimates in short to medium run at p-values of .9"
	tab cntrycode if pvalue <= .1 & independence_years >= 0 & independence_years <= 10
	local n = r(r)
	sum cntrycode if PTDIDD != . & independence_years == 0
	local share = round(`n'/`r(N)'*100,.1)
	noi di "`share'%"
	restore
			
	keep if independence_years >= 0 & independence_years <= 30
	
	cd ".\5. TeX results"	
	listtab independence_years p90_m p90_p p90_n pe_mean pe_min pe_p25 pe_median pe_p75 pe_max ///
	using tableA5.tex,  replace ///
	rstyle(tabular) ///
	headlines("\begin{tabular}{cccccccccc}\toprule \\ \emph{$ s $} & \emph{$\bar{\beta}_{s} < 0$} & \emph{$\bar{\beta}_{s} > 0$} & \emph{$\bar{\beta}_{s}$ = 0} & \emph{$\bar{\beta}$} & \emph{$\beta^{min}$} & \emph{$\beta^{p25}$} & \emph{$\beta^{p50}$} & \emph{$\beta^{p75}$} & \emph{$\beta^{max}$}\\ \midrule") ///
	footlines("\bottomrule \end{tabular}")
	cd ..			

	* Reroute to directory containing dofiles
	cd ".\1. Dofiles"
	}
